<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Models\User\EmailVerification;

use Erlage\Photogram\System;
use Erlage\Photogram\Data\Models\InterfaceModelBuilder;
use Erlage\Photogram\Data\Tables\User\UserEmailVerificationTable;

final class UserEmailVerificationBuilder implements InterfaceUserEmailVerificationSetter, InterfaceModelBuilder
{
    /**
     * setter interface
     */
    use TraitUserEmailVerificationSetters;

    /*
    |--------------------------------------------------------------------------
    | default values
    |--------------------------------------------------------------------------
    */

    /**
     * @var array
     */
    public $defaultValues;

    public function __construct()
    {
        $this -> defaultValues = self::defaultValues();
    }

    public static function defaultValues(): array
    {
        return array(
            UserEmailVerificationTable::USER_ID => '',

            UserEmailVerificationTable::META_ACCESS_OTP    => '',
            UserEmailVerificationTable::META_TIMES_FAILED  => '0',
            UserEmailVerificationTable::META_IS_EXPIRED    => UserEmailVerificationEnum::META_IS_EXPIRED_NO,

            UserEmailVerificationTable::STAMP_REGISTRATION => System::isoDateTime(),
            UserEmailVerificationTable::STAMP_LAST_UPDATE  => System::isoDateTime(),
        );
    }

    public function dispense(): UserEmailVerificationModel
    {
        return UserEmailVerificationModel::createFromData(
            array(
                // user id

                UserEmailVerificationTable::USER_ID => $this -> userId

                ?? $this -> defaultValues[UserEmailVerificationTable::USER_ID],

                // meta access otp

                UserEmailVerificationTable::META_ACCESS_OTP => $this -> metaAccessOTP

                ?? $this -> defaultValues[UserEmailVerificationTable::META_ACCESS_OTP],

                // meta times failed

                UserEmailVerificationTable::META_TIMES_FAILED => $this -> metaTimesFailed

                ?? $this -> defaultValues[UserEmailVerificationTable::META_TIMES_FAILED],

                // meta is expired

                UserEmailVerificationTable::META_IS_EXPIRED => $this -> metaIsExpired

                ?? $this -> defaultValues[UserEmailVerificationTable::META_IS_EXPIRED],

                // stamp registration

                UserEmailVerificationTable::STAMP_REGISTRATION => $this -> stampRegistration

                ?? $this -> defaultValues[UserEmailVerificationTable::STAMP_REGISTRATION],

                // stamp last update

                UserEmailVerificationTable::STAMP_LAST_UPDATE => $this -> stampLastUpdate

                ?? $this -> defaultValues[UserEmailVerificationTable::STAMP_LAST_UPDATE],
            )
        );
    }
}
